﻿package com.common;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateHelper {

	static public final String SystemDateFormat = "yyyy-MM-dd";
	static public final String DateTimeFormat = "yyyy-MM-dd HH:mm:ss";
	static public final String YYYYMM = "yyyyMM";
	static public final String YYYYMMDD = "yyyyMMdd";
	static public final String YYMMDD = "yyMMdd";
	static public final String YYMMDDHHMMSS = "yyMMddHHmmss";
	static public final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
	static public final String YYYYMMDDHHMMSSFFF = "yyyyMMddHHmmssSSS";
	static public final String YYMMDDHHMMSSSSS = "yyMMddHHmmssSSS";

	static public String Date2String(java.sql.Timestamp time, String format) {
		if (time == null)
			return null;
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		return sdf.format(time);
	}

	static public String Date2String(java.util.Date date, String format) {
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		return sdf.format(date);
	}

	/**
	 * 格式：yyyy-MM-dd
	 * 
	 * @param time
	 * @return
	 */
	static public String Date2SystemFormatString(java.sql.Timestamp time) {
		return Date2String(time, "yyyy-MM-dd");
	}

	/**
	 * 格式：yyyy-MM-dd HH:mm:ss
	 * 
	 * @param timestamp
	 * @return
	 */
	static public String toDateTimeString(java.sql.Timestamp timestamp) {
		return Date2String(timestamp, DateTimeFormat);
	}

	static public Timestamp String2Timsestamp(String strdate) {
		return String2Date(strdate, DateTimeFormat);
	}

	static public Timestamp Date2Timsestamp(Date date) {
		try {
			return new Timestamp(date.getTime());
		} catch (Exception e) {
			return new Timestamp(new Date().getTime());
		}
	}

	static public java.sql.Date Date2SqlDate(Date date) {
		try {
			return new java.sql.Date(date.getTime());
		} catch (Exception e) {
			return new java.sql.Date(new Date().getTime());
		}
	}

	static public java.sql.Timestamp Date2SqlTimestamp(Date date) {
		try {
			return new java.sql.Timestamp(date.getTime());
		} catch (Exception e) {
			return new java.sql.Timestamp(new Date().getTime());
		}
	}

	static public java.sql.Date getNowSqlDate() {
		try {
			return new java.sql.Date(getNowDate().getTime());
		} catch (Exception e) {
			return new java.sql.Date(new Date().getTime());
		}
	}

	static public Timestamp getNowSqlDateTime() {
		try {
			return new Timestamp(new Date().getTime());
		} catch (Exception e) {
			return new Timestamp(new Date().getTime());
		}
	}

	/**
	 * @param dateString
	 * @param formatString
	 * @return
	 */
	static public Timestamp String2Date(String dateString, String formatString) {
		try {
			dateString = dateString.replace("T", " ");
			if (dateString.indexOf("+") > 0) {
				dateString = dateString.substring(0, dateString.indexOf("+"));
			}

			SimpleDateFormat format = new SimpleDateFormat(formatString);
			Date date = format.parse(dateString);

			return new Timestamp(date.getTime());
		} catch (Exception e) {
			return new Timestamp(new Date().getTime());
		}
	}

	public static Date String2Date(String str) {
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		Date date = null;
		try {
			date = df.parse(str);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return date;
	}

	/**
	 * 获取现在时间
	 * 
	 * @return 返回时间类型 yyyy-MM-dd HH:mm:ss
	 */
	public static Date getNowDate() {
		Date currentTime = new Date();
		return currentTime;
		/*
		 * SimpleDateFormat formatter = new
		 * SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); String dateString =
		 * formatter.format(currentTime); ParsePosition pos = new
		 * ParsePosition(8); Date currentTime_2 = formatter.parse(dateString,
		 * pos); return currentTime_2;
		 */
	}

	/**
	 * @param dateStr
	 * @return 返回日期类型 yyyy-MM-dd
	 */
	static public java.sql.Date String2ShortDate(String dateStr) {
		try {
			SimpleDateFormat format = new SimpleDateFormat(SystemDateFormat);
			Date date = format.parse(dateStr);
			return new java.sql.Date(date.getTime());
		} catch (Exception e) {
			return new java.sql.Date(new Date().getTime());
		}
	}

	/**
	 * 
	 * @return 格式yyyy-MM-dd
	 */
	static public String GetNowDateString() {
		Date now = new Date();
		SimpleDateFormat df = new SimpleDateFormat(SystemDateFormat);
		return df.format(now);
	}
	
	static public String GetNowDateString(Date now)
	{
		SimpleDateFormat df = new SimpleDateFormat(SystemDateFormat);
		return df.format(now);
	}
	
	static public int GetNowYear()
	{
		Calendar cal = Calendar.getInstance(); 
		return cal.get(cal.YEAR);
	}

	/**
	 * 
	 * @return 格式YYYYMM
	 */
	static public String GetNowYearAndMonth() {
		Date now = new Date();
		SimpleDateFormat df = new SimpleDateFormat(YYYYMM);
		return df.format(now);
	}

	/**
	 * 返回当前日期的字符串
	 * 
	 * @return 格式YYYYMMDD
	 */
	static public String GetNowDateNoSplitString() {
		Date now = new Date();
		SimpleDateFormat df = new SimpleDateFormat(YYYYMMDD);
		return df.format(now);
	}

	/**
	 * 返回当前日期的字符串
	 * 
	 * @return 格式YYYYMMDDHHMMSS
	 */
	static public String GetNowDateTimeNoSplitString() {
		Date now = new Date();
		SimpleDateFormat df = new SimpleDateFormat(YYYYMMDDHHMMSS);
		return df.format(now);
	}
	
	static public String GetNowDateTimeFFFNoSplitString(){
		Date now = new Date();
		SimpleDateFormat df = new SimpleDateFormat(YYYYMMDDHHMMSSFFF);
		return df.format(now);
	}
	
	public static void  main(String[] arg)
	{
		System.out.println(GetNowDateTimeFFFNoSplitString());
	}

	/**
	 * 返回当前日期的字符串
	 * 
	 * @return 格式yyyy-MM-dd HH:mm:ss
	 */
	static public String GetNowDateTimeString() {
		Date now = new Date();
		SimpleDateFormat df = new SimpleDateFormat(DateTimeFormat);
		return df.format(now);
	}

	/**
	 * 取昨天日期的字符串
	 * 
	 * @return 格式YYYYMMDD
	 */
	static public String GetYesterDayString() {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DATE, -1);
		String yesterday = new SimpleDateFormat(YYYYMMDD).format(cal.getTime());
		return yesterday;
	}

	/**
	 * 获取昨天
	 * 
	 * @return
	 */
	static public String GetYesterDateString() {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DATE, -1);
		String yesterday = new SimpleDateFormat(SystemDateFormat).format(cal
				.getTime());
		return yesterday;
	}

	/**
	 * 取昨天日期对应的年
	 * 
	 * @return
	 */
	static public int GetYesterYear() {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DATE, -1);
		return cal.get(cal.YEAR);
	}

	/**
	 * 取昨天日期对应的月
	 * 
	 * @return
	 */
	static public int GetYesterMonth() {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DATE, -1);
		return cal.get(cal.MONTH);
	}

	static public String GetNowDay() {
		Date now = new Date();
		SimpleDateFormat df = new SimpleDateFormat("d");
		return df.format(now);
	}

	/**
	 * 返回两时间的差，单位：分钟
	 * 
	 * @param beginDate
	 * @param endDate
	 * @return
	 */
	public static float GetDateDiff(Date beginDate, Date endDate) {
		long time1 = beginDate.getTime();
		long time2 = endDate.getTime();
		long diff = Math.abs(time2 - time1);
		return (float) (Math.round((diff / 1000 / 60f) * 100)) / 100;
	}

	/**
	 * 比较两个时间大小
	 * 
	 * @param DATE1
	 * @param DATE2
	 * @return true标识 DATE1>DATE2 false<
	 */
	public static boolean Compare2Date(String DATE1, String DATE2) {
		DateFormat df = new SimpleDateFormat(DateTimeFormat);
		try {
			Date dt1 = df.parse(DATE1);
			Date dt2 = df.parse(DATE2);
			if (dt1.getTime() > dt2.getTime()) {
				return true;
			} else if (dt1.getTime() < dt2.getTime()) {
				return false;
			}
		} catch (Exception exception) {
			Log.error(exception.toString());
		}
		return true;
	}

	/**
	 * 计算两个日期之间相差的天数
	 * 
	 * @param smdate
	 *            较小的时间
	 * @param bdate
	 *            较大的时间
	 * @return 相差天数
	 * @throws ParseException
	 */
	public static int daysBetween(Date smdate, Date bdate)
			throws ParseException {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		smdate = sdf.parse(sdf.format(smdate));
		bdate = sdf.parse(sdf.format(bdate));
		Calendar cal = Calendar.getInstance();
		cal.setTime(smdate);
		long time1 = cal.getTimeInMillis();
		cal.setTime(bdate);
		long time2 = cal.getTimeInMillis();
		long between_days = (time2 - time1) / (1000 * 3600 * 24); 
		return Integer.parseInt(String.valueOf(between_days));
	}
	
	/**
	 * 计算两个日期之间相差的天数
	 * 
	 * @param smdate
	 *            较小的时间
	 * @param bdate
	 *            较大的时间
	 * @return 相差天数
	 * @throws ParseException
	 */
	public static int daysBetween(String _smdate, String _bdate)
			throws ParseException {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date smdate=sdf.parse(_smdate);  
        Date bdate=sdf.parse(_bdate);  
		smdate = sdf.parse(sdf.format(smdate));
		bdate = sdf.parse(sdf.format(bdate));
		Calendar cal = Calendar.getInstance();
		cal.setTime(smdate);
		long time1 = cal.getTimeInMillis();
		cal.setTime(bdate);
		long time2 = cal.getTimeInMillis();
		long between_days = (time2 - time1) / (1000 * 3600 * 24); 
		return Integer.parseInt(String.valueOf(between_days));
	}
	
	/**
	 * 现在时间与相差指定秒数
	 * @param nowTime
	 * @param ss
	 * @return true 在指定秒数内 false 超过指定秒数
	 */
	public static boolean TimeSpanBetween(String nowTime,int ss)
	{
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String strSubTime=nowTime.substring(0,10);
		String strFirsdTime=strSubTime+" 00:00:00";
		String strEndTime=strSubTime+" 23:59:59";
		try {
			Date nowDate=df.parse(nowTime);
			Date firsdDate=df.parse(strFirsdTime);
			Date endDate=df.parse(strEndTime);
			long lfirst=(nowDate.getTime()-firsdDate.getTime())/1000;
			long lend=Math.abs((nowDate.getTime()-endDate.getTime())/1000);
			if(lfirst<ss||lend<ss)
			{
				return true;
			}
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
		return false; 
	}
	
}
