package com.common;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

import org.apache.commons.lang.StringUtils; 

public class DateUtil {
	//private static final Logger log = Logger.getLogger(DateUtil.class);
	public static final String YYYY_MM_DD = "yyyy-MM-dd";
	public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
	public static final String YYYYMMDD = "yyyyMMdd";
	public static final String YYMMDD = "yyMMdd";
	public static final String YYMMDDHHMMSS = "yyMMddHHmmss";
	public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
	public static final String YYMMDDHHMMSSSSS = "yyMMddHHmmssSSS";
	public static final String YYYY = "yyyy";
	public static final String MM = "MM";
	public static final String YYYY_MM = "yyyy_MM";
	public static long nd = 1000*24*60*60;//一天的毫秒数
	public static long nh = 1000*60*60;//一小时的毫秒数
	public static long nm = 1000*60;//一分钟的毫秒数
	public static long ns = 1000;//一秒钟的毫秒数
	private static ThreadLocal<Map<String, DateFormat>> threadLocal = new ThreadLocal<Map<String, DateFormat>>() {
	protected Map<String, DateFormat> initialValue() {
			return new HashMap<String, DateFormat>();
		}
	};
	/**
	 * 针对天翼那边。用时间生成订单号
	 * @return
	 */
	public static String getCurrentDate() {
		Calendar cal = Calendar.getInstance();
		int year = cal.get(cal.YEAR);
		int month = cal.get(cal.MONTH) + 1;
		int day = cal.get(cal.DAY_OF_MONTH);
		int hour = cal.get(cal.HOUR_OF_DAY);
		int minute = cal.get(cal.MINUTE);
		int second = cal.get(cal.SECOND);
		String cDate = Integer.toString(year);
		if (month < 10) {
			cDate = cDate + "0" + Integer.toString(month);
		} else {
			cDate = cDate + Integer.toString(month);
		}
		if (day < 10) {
			cDate = cDate + "0" + Integer.toString(day);
		} else {
			cDate = cDate + Integer.toString(day);
		}
		if (hour < 10) {
			cDate = cDate + "0" + Integer.toString(hour);
		} else {
			cDate = cDate + Integer.toString(hour);
		}
		if (minute < 10) {
			cDate = cDate + "0" + Integer.toString(minute);
		} else {
			cDate = cDate + Integer.toString(minute);
		}
		if (second < 10) {
			cDate = cDate + "0" + Integer.toString(second);
		} else {
			cDate = cDate + Integer.toString(second);
		}
		return cDate.trim();
	}
	
	/**
	 * 计算日期相隔多少天
	 * 
	 * @param sdate
	 * @param edate
	 * @return
	 */
	public static int betweenDays(Date sdate, Date edate) {
		Calendar beginDate = getCalendar(sdate);
		Calendar endDate = getCalendar(edate);
		return betweenDays(beginDate, endDate);
	}
	
	/**
	 * 计算日期相隔多少分钟
	 * 
	 * @param sdate
	 * @param edate
	 * @return
	 */
	public static long betweenminutes(String sdate, String edate,String format) {		
		SimpleDateFormat sdf=new SimpleDateFormat(format);		
		try {
			long diff = sdf.parse(sdate).getTime()-sdf.parse(edate).getTime();
			long min = diff%nd%nh/nm;//计算差多少分钟
			return min;
		}catch (ParseException e) {			
			e.printStackTrace();
			return 0;
		}
	}
	/**
	 * 计算日期相隔多少小时
	 * @param startTime
	 * @param endTime
	 * @param format
	 */
	public static long betweenHours(String sdate,String edate,String format) {		
		SimpleDateFormat sdf=new SimpleDateFormat(format);
		long hour;
		try {
			long diff = sdf.parse(sdate).getTime()-sdf.parse(edate).getTime();
			hour = diff%nd/nh;//计算差多少小时
			return hour;
		}catch (ParseException e) {			
			e.printStackTrace();
			return 0;
		}
	}
	/**
	 * 计算日期相隔多少秒
	 * @param startTime
	 * @param endTime
	 * @param format
	 */
	public static long betweenSecond(String sdate, String edate,String format) {		
		SimpleDateFormat sdf=new SimpleDateFormat(format);		
		try {
			long diff = sdf.parse(sdate).getTime()-sdf.parse(edate).getTime();
			long sec = diff%nd%nh%nm/ns;//计算差多少秒
			return sec;
		}catch (ParseException e) {			
			e.printStackTrace();
			return 0;
		}
	} 
	
	public static Calendar getCalendar(Date date) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		int year = calendar.get(Calendar.YEAR);
		int month = calendar.get(Calendar.MONTH) + 1;
		int day = calendar.get(Calendar.DATE);
		calendar.set(year, month, day);
		return calendar;
	}

	/**
	 * 给指定的时间Date增加monthNum个月份
	 * @param date
	 * @param monthNum
	 * @return 返回增加月份后的时间
	 */
	public static Date addDateMonth(Date date, int monthNum){
		if (monthNum <= 0){
			return date;
		}
		Calendar calendar = Calendar.getInstance();;
		calendar.setTime(date);
		calendar.add(Calendar.MONTH, monthNum);
		return calendar.getTime();
	}
	
	/**
	 * <li>功能描述：时间相减得到天数
	 * 
	 * @param beginDateStr
	 * @param endDateStr
	 * @return long
	 * @author Administrator
	 */
	public static long getDaySub(String beginDateStr, String endDateStr) {
		long day = 0;
		java.text.SimpleDateFormat format = new java.text.SimpleDateFormat(YYYY_MM_DD);
		java.util.Date beginDate;
		java.util.Date endDate;
		try {
			beginDate = format.parse(beginDateStr);
			endDate = format.parse(endDateStr);
			day = (endDate.getTime() - beginDate.getTime()) / (24 * 60 * 60 * 1000);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return day;
	}

	/**
	 * 计算日期相隔多少天
	 * 
	 * @param beginDate
	 * @param endDate
	 * @return
	 */
	public static int betweenDays(Calendar beginDate, Calendar endDate) {
		if (beginDate.get(Calendar.YEAR) == endDate.get(Calendar.YEAR)) {
			return endDate.get(Calendar.DAY_OF_YEAR) - beginDate.get(Calendar.DAY_OF_YEAR);
		} else {
			if (beginDate.getTimeInMillis() < endDate.getTimeInMillis()) {
				int days = beginDate.getActualMaximum(Calendar.DAY_OF_YEAR) - beginDate.get(Calendar.DAY_OF_YEAR) + endDate.get(Calendar.DAY_OF_YEAR);
				for (int i = beginDate.get(Calendar.YEAR) + 1; i < endDate.get(Calendar.YEAR); i++) {
					Calendar c = Calendar.getInstance();
					c.set(Calendar.YEAR, i);
					days += c.getActualMaximum(Calendar.DAY_OF_YEAR);
				}
				return days;
			} else {
				int days = endDate.getActualMaximum(Calendar.DAY_OF_YEAR) - endDate.get(Calendar.DAY_OF_YEAR) + beginDate.get(Calendar.DAY_OF_YEAR);
				for (int i = endDate.get(Calendar.YEAR) + 1; i < beginDate.get(Calendar.YEAR); i++) {
					Calendar c = Calendar.getInstance();
					c.set(Calendar.YEAR, i);
					days += c.getActualMaximum(Calendar.DAY_OF_YEAR);
				}
				return days;
			}
		}
	}

	public static DateFormat getDateFormat(String dateFormat) {
		Map<String, DateFormat> map = threadLocal.get();
		DateFormat df = map.get(dateFormat);
		if (df == null) {
			df = new SimpleDateFormat(dateFormat);
			map.put(dateFormat, df);
		}
		return df;
	}

	/**
	 * 返回当前系统时间的时间戳
	 * @return
	 */
	public static Timestamp getCurrentTimestamp(){
		
		return new Timestamp(System.currentTimeMillis());
	}
	
	// 获取当前时间
	public static String getcurrentTime() {
		String current = DateUtil.dateToString(new Date(), DateUtil.YYYY_MM_DD_HH_MM_SS);
		return current;
	}
	//获取当前时间 并转换成指定格式
	public static String getcurrentTimeToFormat(String dateFormat){
		String current = DateUtil.dateToString(new Date(), dateFormat);
		return current;
	}
	
	
	// 获取上个月的时间
	public static String getlastMonTime() {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.MONTH, 1);
		String current = DateUtil.dateToString(new Date(cal.getTime().getTime()), DateUtil.YYYY_MM_DD_HH_MM_SS);
		return current;
	}

	public static long getlastMothTime() {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.MONTH, 1);
		return cal.getTime().getTime();
	}

	/**
	 * 获取与给定日期参数相差天的日期
	 * 
	 * @param date
	 * @param differdays
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static Date newDate(Date srcDate, int differdays) {
		Date date = new Date(srcDate.getTime());
		if (date == null) {
			return new Date();
		}
		date.setDate(date.getDate() + differdays);
		return date;
	}

	/**
	 * 根据传入的日期，格式化为指定的日期格式
	 * 
	 * @param date
	 *            日期参数
	 * @param dateFormat
	 *            格式 例如:yyyy-MM-dd
	 * @return
	 */
	public static String dateToString(Date date, String dateFormat) {
		try {
			if (date == null) {
				return null;
			}
			return getDateFormat(dateFormat).format(date);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 将日期转化为字符串，默认格式为yyyy-MM-dd
	 * 
	 * @param date
	 * @return
	 */
	public static String dateToString(Date date) {
		try {
			if (date == null) {
				return "";
			}
			return getDateFormat(YYYY_MM_DD).format(date);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 根据传入的日期，可根据differdays 参数设置到另一日期，再格式化日期
	 * 
	 * @param date
	 *            日期参数
	 * @param differdays
	 *            与给定的日期相差天数 负数表示指定日期前多少天 正数表示日期后多少天
	 * @param dateFormat
	 *            格式 例如:yyyy-MM-dd
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static String dateToString(Date srcDate, int differdays, String dateFormat) {
		Date date = new Date(srcDate.getTime());
		date.setDate(date.getDate() + differdays);
		try {
			return getDateFormat(dateFormat).format(date);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 获取指定参数在一年中所处的周期
	 * 
	 * @param date
	 * @param differdays
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static String getWeek(Date srcDate, int differdays) {
		Date date = new Date(srcDate.getTime());
		date.setDate(date.getDate() + differdays);
		return getDateFormat("w").format(date);
	}

	/**
	 * 根据给定日期，按需要转换的格式转换成字符串
	 * 
	 * @param dateString
	 * @param dateFormat
	 * @return
	 */
	public static Date stringToDate(String dateString, String dateFormat) {
		try {
			if (StringUtils.isEmpty(dateString)) {
				return null;
			}
			return getDateFormat(dateFormat).parse(dateString);
		} catch (Exception e) {
			//log.error("日期格式转换错误", e);
		}
		return null;
	}

	/**
	 * 获取一月中的最后一天
	 * 
	 * @param date
	 * @param differdays
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static Date getLastDayOfMonth(Date srcDate, int differdays) {
		Date date = new Date(srcDate.getTime());
		date.setDate(date.getDate() + differdays);
		Calendar cDay1 = Calendar.getInstance();
		cDay1.setTime(date);
		final int lastDay = cDay1.getActualMaximum(Calendar.DAY_OF_MONTH);
		Date lastDate = cDay1.getTime();
		lastDate.setDate(lastDay);
		return lastDate;
	}

	/**
	 * 获取一月中的第一天
	 * 
	 * @param date
	 * @param differdays
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static Date getFirstDayOfMonth(Date srcDate, int differdays) {
		Date date = new Date(srcDate.getTime());
		date.setDate(date.getDate() + differdays);
		Calendar cDay1 = Calendar.getInstance();
		cDay1.setTime(date);
		final int lastDay = cDay1.getActualMinimum(Calendar.DAY_OF_MONTH);
		Date lastDate = cDay1.getTime();
		lastDate.setDate(lastDay);
		return lastDate;
	}

	/**
	 * 获取给定日期所在周的第一天的时间
	 * 
	 * @param date
	 * @param differdays
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static Date getFirstDayOfWeek(Date srcDate, int differdays) {
		Date date = new Date(srcDate.getTime());
		date.setDate(date.getDate() + differdays);
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		Date firstDateOfWeek; // 得到当天是这周的第几天
		int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK); // 减去dayOfWeek,得到第一天的日期，因为Calendar用０－６代表一周七天，所以要减一
		calendar.add(Calendar.DAY_OF_WEEK, -(dayOfWeek - 1));
		firstDateOfWeek = calendar.getTime(); // 每周7天，加６，得到最后一天的日子
		return firstDateOfWeek;
	}

	/**
	 * 获取一周中的最后一天
	 * 
	 * @param date
	 * @param differdays
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static Date getLastDayOfWeek(Date srcDate, int differdays) {
		Date date = new Date(srcDate.getTime());
		date.setDate(date.getDate() + differdays);
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		Date lastDateOfWeek; // 得到当天是这周的第几天
		int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK); // 减去dayOfWeek,得到第一天的日期，因为Calendar用０－６代表一周七天，所以要减一
		calendar.add(Calendar.DAY_OF_WEEK, -(dayOfWeek - 1));
		calendar.add(Calendar.DAY_OF_WEEK, 6);
		lastDateOfWeek = calendar.getTime();
		return lastDateOfWeek;
	}

	/**
	 * 获取一年中的第一个月
	 * 
	 * @param date
	 * @param differmonths
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static Date getFirstMonthOfYear(Date srcDate, int differmonths) {
		Date date = new Date(srcDate.getTime());
		date.setMonth(date.getMonth() + differmonths);
		Calendar cDay1 = Calendar.getInstance();
		cDay1.setTime(date);
		date.setDate(cDay1.getActualMinimum(Calendar.DAY_OF_MONTH));
		date.setMonth(cDay1.getActualMinimum(Calendar.MONTH));
		return getFirstSecondOfOneDay(date);
	}

	/**
	 * 获取一年中的最后一月
	 * 
	 * @param date
	 * @param differmonths
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static Date getLastMonthOfYear(Date srcDate, int differmonths) {
		Date date = new Date(srcDate.getTime());
		date.setMonth(date.getMonth() + differmonths);
		Calendar cDay1 = Calendar.getInstance();
		cDay1.setTime(date);
		date.setDate(cDay1.getActualMaximum(Calendar.DAY_OF_MONTH));
		date.setMonth(cDay1.getActualMaximum(Calendar.MONTH));
		return getLastSecondOfOneDay(date);
	}

	/**
	 * 获取一天中的第一秒时间
	 * 
	 * @param date
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static Date getFirstSecondOfOneDay(Date srcDate) {
		Date date = new Date(srcDate.getTime());
		Calendar c = Calendar.getInstance();
		date.setHours(c.getActualMinimum(Calendar.HOUR_OF_DAY));
		date.setMinutes(c.getActualMinimum(Calendar.MINUTE));
		date.setSeconds(c.getActualMinimum(Calendar.SECOND));
		return date;
	}

	/**
	 * 获取一天中最后一秒时间
	 * 
	 * @param date
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static Date getLastSecondOfOneDay(Date srcDate) {
		Date date = new Date(srcDate.getTime());
		Calendar c = Calendar.getInstance();
		date.setHours(c.getActualMaximum(Calendar.HOUR_OF_DAY));
		date.setMinutes(c.getActualMaximum(Calendar.MINUTE));
		date.setSeconds(c.getActualMaximum(Calendar.SECOND));
		return date;
	}

	/**
	 * 获取指定时区时间
	 * @return
	 */
	public static Date newDate(String timeZone){
		Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timeZone),Locale.CHINESE);
        Calendar day = Calendar.getInstance();
        day.set(Calendar.YEAR, cal.get(Calendar.YEAR));
        day.set(Calendar.MONTH, cal.get(Calendar.MONTH));
        day.set(Calendar.DATE, cal.get(Calendar.DATE));
        day.set(Calendar.HOUR_OF_DAY, cal.get(Calendar.HOUR_OF_DAY));
        day.set(Calendar.MINUTE, cal.get(Calendar.MINUTE));
        day.set(Calendar.SECOND, cal.get(Calendar.SECOND));
        return day.getTime();
	}
	
	@SuppressWarnings("deprecation")
	public static void main(String[] args) {
		/*
		 * Date date = new Date(); date = getFirstMonthOfYear(date, 0);
		 * // (date.toLocaleString());
		 */
		Date date2 = new Date("Sat Dec 15 18:06:08 +0800 2012");

		// ("day " + dateToString(date2, "yyyy-MM-dd HH:mm:ss"));
	}

}