package com.common;

import javax.servlet.http.HttpServletRequest;

public class HtmlHelper {

	static public String GetValue(HttpServletRequest request, String field)
	{		
		if(request == null || StringHelper.IsNullOrEmpty(field))
		{
			return "";
		}
		Object tempObj = request.getAttribute(field);
		if(tempObj == null)
		{
			return "";
		}
		return StringHelper.ReplaceInvalidChar(tempObj.toString());
	}
	
	static public String ReplaceInvalidChar(String value)
	{	 
		if(StringHelper.IsNullOrEmpty(value))
		{
			return "";
		} 
		return StringHelper.ReplaceInvalidChar(value).replace("\r\n", "<br>"); 
	}
	
	static public String ReplaceSingleQuoteCharOnly(String value)
	{	 
		if(StringHelper.IsNullOrEmpty(value))
		{
			return "";
		} 
		return value.replace("'", "\\\'"); 
	}
	
	static public String ReplaceDoubleQuoteCharOnly(String value)
	{	 
		if(StringHelper.IsNullOrEmpty(value))
		{
			return "";
		} 
		return value.replace("\"", "\\\""); 
	}
	
	public static void main(String[] args) {	 
        String tempStr = "czf\"123\'456";
		System.out.println(tempStr); 
		System.out.println(ReplaceDoubleQuoteCharOnly(ReplaceSingleQuoteCharOnly(tempStr))); 
	}
}
