package com.common;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.CoreConnectionPNames;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;

public class HttpClientUrl {

	public static String codec(String inputCharset) {
		String charset = "gb2312";
		try {
			return URLEncoder.encode(inputCharset, charset);// 转码，charset为目标码
		} catch (UnsupportedEncodingException e) {
			return inputCharset; // 异常返回原字符
		}
	}

	/**
     * 向指定URL发送GET方法的请求
     * 
     * @param url
     *            发送请求的URL
     * @param param
     *            请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
     * @return URL 所代表远程资源的响应结果
     */
    public static String sendGet(String url, String param) {
        String result = "";
        BufferedReader in = null;
        try {
        	String urlParam = param.contains("?") ? "&" + param : "?" + param;
            String urlNameString = url + urlParam;
            URL realUrl = new URL(urlNameString);
            // 打开和URL之间的连接
            URLConnection connection = realUrl.openConnection();
            // 设置通用的请求属性
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
           // connection.setRequestProperty(key, value)
            connection.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
            // 建立实际的连接
            connection.connect();
            // 获取所有响应头字段
//            Map<String, List<String>> map = connection.getHeaderFields();
            // 遍历所有的响应头字段
//            for (String key : map.keySet()) {
//                System.out.println(key + "--->" + map.get(key));
//            }
            // 定义 BufferedReader输入流来读取URL的响应
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(),"utf-8"));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            Log.error("sendGet发送GET请求出现异常！" + e +"urlNameString:"+url+"?"+param); 
        }
        // 使用finally块来关闭输入流
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }
    
    public static String sendPostUTF8(String url,String params) {
    	String strRe="";
		StringBuffer bufferRes = new StringBuffer();
		HttpURLConnection conn=null;
		try {
			URL realUrl = new URL(url);
			conn = (HttpURLConnection) realUrl.openConnection();
			
			// 连接超时
			conn.setConnectTimeout(25000);
			// 读取超时 --服务器响应比较慢，增大时间
			conn.setReadTimeout(25000);
			
			HttpURLConnection.setFollowRedirects(true);
			// 请求方式
			conn.setRequestMethod("GET");
			conn.setDoOutput(true);
			conn.setDoInput(true);
			conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:21.0) Gecko/20100101 Firefox/21.0");
			conn.setRequestProperty("Referer", "https://api.weixin.qq.com/");
			conn.connect();
			// 获取URLConnection对象对应的输出流
			OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
			// 发送请求参数
			//out.write(URLEncoder.encode(params,"UTF-8"));
			out.write(params);
			out.flush();
			out.close();
			
			InputStream in = conn.getInputStream();
			BufferedReader read = new BufferedReader(new InputStreamReader(in,"UTF-8"));
			String valueString = null;
			while ((valueString=read.readLine())!=null){
				bufferRes.append(valueString);
			}
			strRe=bufferRes.toString();
			in.close();
			if (conn != null) {
				// 关闭连接
				conn.disconnect();
				conn=null;
			}
		} catch (Exception e) {
			Log.error("sendPostUTF8"+e);
		}
		finally
		{
			if (conn != null) {
				// 关闭连接
				conn.disconnect();
				conn=null;
			}
		}
		return strRe;
	}
    
    public static String doPost(String url, String JSONStr) {
    	try
    	{
    		HttpClient client = new DefaultHttpClient();
            // 请求超时
            client.getParams().setParameter(CoreConnectionPNames.CONNECTION_TIMEOUT, 8000);
            // 读取超时
            client.getParams().setParameter(CoreConnectionPNames.SO_TIMEOUT, 8000);
 			HttpPost post = new HttpPost(url);  
			StringEntity entity = new StringEntity(JSONStr, "UTF-8");
			entity.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE, "application/json"));
			entity.setContentType("application/json");
			post.setEntity(entity);
			HttpResponse response = client.execute(post);
			return EntityUtils.toString(response.getEntity(), "UTF-8");
    	}
    	catch(Exception e)
    	{
    		return "";
    	}
	}

	public static String sendPost(String strurl, String data) {
		// 发送的请求参数，发送的格式也是Json的
		String strResult = "";
		try {
			// 请求的地址
			URL url = new URL(strurl);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			// 连接超时
			conn.setConnectTimeout(25000);
			// 读取超时 --服务器响应比较慢，增大时间
			conn.setReadTimeout(25000);
			// 发送Post强求，开启其读写的功能
			conn.setDoOutput(true);
			conn.setDoInput(true);
			// 这些参数是看了网上有人的建议，用上之后效果不大
			conn.setRequestProperty("accpt",
					"  text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
			conn.setRequestProperty("User-Agent",
					"  Mozilla/5.0 (Windows NT 6.1; rv:27.0) Gecko/20100101 Firefox/27.0");
			conn.setRequestProperty("X-Requested-With", "XMLHttpRequest");
			conn.setRequestProperty("Connection", "  keep-alive");
			conn.setRequestProperty("Cookie",
					"  SP.NET_SessionId=rtznindc2qwycf45ixyji2rr");
			conn.setRequestMethod("POST");
			// 发送Post请求
			conn.getOutputStream().write(data.getBytes("utf8"));
			conn.getOutputStream().flush();
			conn.getOutputStream().close();
			conn.connect();
			// 解析响应信息，用了很多种，用了字节流啊，处理流都试过了，这是最后试的那个
			// 主要是不能解决乱码问题，响应的东西还是能够收到，就是乱码
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			byte[] buf = new byte[1024];
			int len = 0;
			InputStream is = conn.getInputStream();
			while ((len = is.read(buf)) != -1) { 
				baos.write(buf, 0, len);
			}
			baos.flush();
			// 这个utf8给予了太多的希望
			strResult = baos.toString("utf8");
			baos.close();
			is.close();
		} catch (MalformedURLException ex) {
			ex.printStackTrace();
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		return strResult;
	}
}