package com.common;

import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;


/**
 * HttpServletRequest帮助类
 * 
 */
public class RequestUtils {
	private static Logger log = Logger.getLogger(RequestUtils.class);
	
	public static byte getByteParameter(HttpServletRequest request,String paramName,byte defaultValue){
		String value = request.getParameter(paramName);
		if(StringUtils.isEmpty(value)){
			return defaultValue;
		}else{
			try{
				return Byte.parseByte(value);
			}catch(Exception e){
				return defaultValue;
			}
		}
	}
	
	public static int getIntParameter(HttpServletRequest request,String paramName,int defaultValue){
		String value = request.getParameter(paramName);
		if(StringUtils.isEmpty(value)){
			return defaultValue;
		}else{
			try{
				return Integer.parseInt(value);
			}catch(Exception e){
				return defaultValue;
			}
		}
	}
	/**
	 * 获取页面提交的所有参数 转换为Map<String,Object>
	 * @param request
	 * @return
	 */
	public static Map<String,Object> getParameterMap(HttpServletRequest request){
		Map<String,String[]> value = request.getParameterMap();		
		if(value==null){
			return null;
		}else{
			try{
				Map<String,Object> map=new HashMap<String, Object>();
				Set<String> keys =value.keySet();
				for (String key:keys) {
					map.put(key.trim(),value.get(key)[0].trim());
				}
				return map;				
			}catch(Exception e){
				e.printStackTrace();
				return null;
			}
		}
	}
	public static long getLongParameter(HttpServletRequest request,String paramName,long defaultValue){
		String value = request.getParameter(paramName);
		if(StringUtils.isEmpty(value)){
			return defaultValue;
		}else{
			try{
				return Long.parseLong(value);
			}catch(Exception e){
				return defaultValue;
			}
		}
	}
	
	public static double getDoubleParameter(HttpServletRequest request,String paramName,double defaultValue){
		String value = request.getParameter(paramName);
		if(StringUtils.isEmpty(value)){
			return defaultValue;
		}else{
			try{
				return Double.parseDouble(value);
			}catch(Exception e){
				return defaultValue;
			}
		}
	}
	

	/**
	 * 从request获取参数名为paramName的参数,并且将其转换为UTF8的格式
	 * @param request
	 * @param paramName
	 * @param defaultValue
	 * @return 如果获取参数则返回正常的参数值,否则返回defaultValue
	 */
	public static String getStringParameter(HttpServletRequest request,String paramName,String defaultValue){
		String value = request.getParameter(paramName);
		if(value == null || StringUtils.isBlank(value.trim())){
			return defaultValue;
		}else{
			if(request.getMethod().equalsIgnoreCase("POST")){
				return value.trim();
			}else{
				try {
					return new String(value.trim().getBytes("iso-8859-1"),"utf-8");
				} catch (Exception e) {
					return defaultValue;
				}
			}
		}
	}

	public static float getFloatParameter(HttpServletRequest request,
			String paramName, float defaultValue) {
		String value = request.getParameter(paramName);
		if(StringUtils.isEmpty(value)){
			return defaultValue;
		}else{
			try{
				return Float.parseFloat(value);
			}catch(Exception e){
				return defaultValue;
			}
		}
	}

	public static Map<String, String> getRequestMap(HttpServletRequest request,
			String prefix) {
		return getRequestMap(request, prefix, false);
	}

	public static Map<String, String> getRequestMapWithPrefix(
			HttpServletRequest request, String prefix) {
		return getRequestMap(request, prefix, true);
	}

	@SuppressWarnings("unchecked")
	private static Map<String, String> getRequestMap(
			HttpServletRequest request, String prefix, boolean nameWithPrefix) {
		Map<String, String> map = new HashMap<String, String>();
		Enumeration<String> names = request.getParameterNames();
		String name, key, value;
		while (names.hasMoreElements()) {
			name = names.nextElement();
			if (name.startsWith(prefix)) {
				key = nameWithPrefix ? name : name.substring(prefix.length());
				value = StringUtils.join(request.getParameterValues(name), ',');
				map.put(key, value);
			}
		}
		return map;
	}

	/**
	 * 获取访问者IP
	 * 
	 * 在一般情况下使用Request.getRemoteAddr()即可，但是经过nginx等反向代理软件后，这个方法会失效。
	 * 
	 * 本方法先从Header中获取X-Real-IP，如果不存在再从X-Forwarded-For获得第一个IP(用,分割)，
	 * 如果还不存在则调用Request .getRemoteAddr()。
	 * 
	 * @param request
	 * @return
	 */
	public static String getIpAddr(HttpServletRequest request) {
		String ip = request.getHeader("X-Real-IP");
		if (!StringUtils.isBlank(ip) && !"unknown".equalsIgnoreCase(ip)) {
			return ip;
		}
		ip = request.getHeader("X-Forwarded-For");
		if (!StringUtils.isBlank(ip) && !"unknown".equalsIgnoreCase(ip)) {
			// 多次反向代理后会有多个IP值，第一个为真实IP。
			int index = ip.indexOf(',');
			if (index != -1) {
				return ip.substring(0, index);
			} else {
				return ip;
			}
		} else {
			return request.getRemoteAddr();
		}
	}



	/**
	 * 获取应用全路径基础地址
	 */
	public static String getBaseURL(HttpServletRequest request){
		return request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+request.getContextPath()+"/";
	}
	
	public static String readRequestAsString(HttpServletRequest request,
			String charset) {
		InputStream i = null;
		String str = null;
		try {
			i =request.getInputStream();
			int a = 0;
			int length = request.getContentLength();
			length = length <= 0 ? 1024 : length;
			byte[] body = new byte[0];
			byte[] tmp = new byte[1024];
			while ((a = i.read(tmp)) != -1) {
				int tmplength = body.length;
				body = new byte[tmplength + a];
				System.arraycopy(tmp, 0, body, tmplength, a);
			}
			str = URLDecoder.decode(new String(body,charset),charset);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return str;
	}
	
	
	
}
