package com.common;

import java.util.List;

public class SqlHelper {
	public static String ReplaceEscapeCharAndTrimForInsert(String val) {
		if (StringHelper.IsNullOrEmpty(val) || val.equals(""))// zqc如果不判断是否为空，调用这个方法会报异常
			return "";

		String result = val.trim().replaceAll("'", "''");

		return result;
	}

	public static String ReplaceEscapeCharAndTrim(String val) {
		if (StringHelper.IsNullOrEmpty(val) || val.equals(""))// zqc如果不判断是否为空，调用这个方法会报异常
			return "";

		return ReplaceEscapeChar(val.trim());
	}

	static public String ReplaceEscapeCharAndTrim_upper(String val) {
		if (StringHelper.IsNullOrEmpty(val))
			return "";

		return SqlHelper.ReplaceEscapeChar(val.trim()).toUpperCase();
	}

	public static String ReplaceEscapeChar(String val) {
		if (StringHelper.IsNullOrEmpty(val))
			return "";

		String result = val.replaceAll("'", "''");
		// result = result.replaceAll("\\[", "\\[\\[\\]");
		// result = result.replaceAll("_", "\\[_\\]");
		// result = result.replaceAll("%", "\\[%\\]");

		// 判断是否需要转义
		/*
		 * if (val.indexOf("_") >= 0 || val.indexOf("%") >= 0 || val.indexOf("\\\\") >= 0) { result = result.replaceAll("\\\\", "\\\\\\\\"); result =
		 * result.replaceAll("_", "\\\\_"); result = result.replaceAll("%", "\\\\%"); }
		 */
		if (val.indexOf("_") >= 0 || val.indexOf("%") >= 0) {
			result = result.replaceAll("_", "◎_");
			result = result.replaceAll("%", "◎%");
		}
		return result;
	}

	/**
	 * 根据条件中是否包括特殊字符，返回如 escape '\' 字符串
	 * 
	 * @return
	 */
	public static String GetEscapeKeyString(String val) {
		if (StringHelper.IsNullOrEmpty(val))
			return "";

		// 判断是否需要转义
		if (val.indexOf("_") >= 0 || val.indexOf("%") >= 0) {
			return " escape '◎'";
		}
		return "";
	}

	/**
	 * 拼凑Sql语句中in后的参数
	 * 
	 * @param params
	 * @return
	 */
	public static String BuildSqlInParams(List<String> params) {
		if (params == null || params.size() == 0)
			return "\'\'";
		int len = params.size();
		StringBuffer sb = new StringBuffer("\'");
		sb.append(params.get(0));
		for (int i = 1; i < len; i++) {
			sb.append("\',\'");
			sb.append(params.get(i));
		}
		sb.append("\'");
		return sb.toString();
	}

}
