﻿package com.common;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;  

public class StringHelper {

	/**
	 * @param content
	 * @return
	 */
	static public int ParseToInt(Object content) {
		if (content == null)
			return -1;

		try {
			return Integer.parseInt(content.toString());
		} catch (Exception e) {
		}

		return -1;
	}

	static public double ParseToDouble(Object val) {
		if (val == null)
			return 0;

		try {
			return Double.parseDouble(val.toString());
		} catch (Exception e) {
		}

		return 0;
	}

	static public float ParseToFloat(Object val) {
		if (val == null)
			return 0;

		try {
			return Float.parseFloat(val.toString());
		} catch (Exception e) {
		}

		return 0;
	}

	static public BigDecimal ParseToBigDecimal(Object val) {
		if (val == null)
			return new BigDecimal(0);

		try {
			return new BigDecimal(val.toString());
		} catch (Exception e) {
		}

		return new BigDecimal(0);
	}

	static public boolean ParseToBool(Object content, boolean defalutVal) {
		if (content == null)
			return defalutVal;

		try {
			return Boolean.parseBoolean(content.toString());
		} catch (Exception e) {
		}

		return defalutVal;
	}

	static private String emptyString = "";

	/**
	 * @return
	 */
	static public String Empty() {
		return StringHelper.emptyString;
	}

	/**
	 * @return
	 */
	static public String CreateGuid() {
		return UUID.randomUUID().toString();
	}

	/**
	 * @param content
	 * @param encoding
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	static public byte[] StringToBytes(String content, String encoding)
			throws UnsupportedEncodingException {
		if (StringHelper.IsNullOrEmpty(content))
			return null;

		if (StringHelper.IsNullOrEmpty(encoding))
			encoding = "utf-8";

		return content.getBytes(encoding);
	}

	/**
	 * @param bytes
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	static public String BytesToString(byte[] bytes, String encoding)
			throws UnsupportedEncodingException {
		if (bytes == null || bytes.length == 0)
			return null;

		if (StringHelper.IsNullOrEmpty(encoding))
			encoding = "utf-8";

		return new String(bytes, encoding);
	}

	/**
	 * @param enumClass
	 * @param val
	 * @return
	 */
	static public Object EnumTryParse(Class enumClass, Object val) {
		if (val == null)
			return null;

		Enum tmp = null;
		EnumSet set = EnumSet.allOf(enumClass);
		for (Object obj : set) {
			tmp = (Enum) obj;
			if (tmp.name().equalsIgnoreCase(val.toString())
					|| ((Integer) tmp.ordinal()).toString().equals(
							val.toString()))
				return tmp;
		}

		return null;
	}

	/**
	 * @param str
	 * @return
	 */
	static public boolean IsNullOrEmpty(String str) {
		return (str == null || str.isEmpty() || str.equals("null"));
	}
	
	static public boolean IsNullOrTrimEmpty(String str){
		return (str == null || str.trim().isEmpty() || str.equals("null"));
	}

	/**
	 * @param str
	 * @param spliters
	 * @param removeEmptys
	 * @return
	 */
	static public String[] Split(String str, String[] spliters,
			boolean removeEmptys) {

		return StringHelper.Split(str, spliters, 0, removeEmptys);
	}

	/**
	 * @param str
	 * @param spliters
	 * @param limit
	 * @param removeEmptys
	 * @return
	 */
	static public String[] Split(String str, String[] spliters, int limit,
			boolean removeEmptys) {
		if (StringHelper.IsNullOrEmpty(str) || spliters == null
				|| spliters.length == 0)
			return null;

		String regex = "";
		for (String spliter : spliters) {
			regex += "\\" + spliter + "|";
		}

		if (regex.endsWith("|"))
			regex = regex.substring(0, regex.lastIndexOf("|"));

		String[] result = str.split(regex, limit);
		if (result == null || result.length == 0)
			return null;

		if (removeEmptys) {
			LinkedList<String> finalList = new LinkedList<String>();
			for (String r : result) {
				if (StringHelper.IsNullOrEmpty(r))
					continue;

				finalList.add(r);
			}

			if (finalList.size() == 0)
				return null;

			String[] array = new String[finalList.size()];
			return finalList.toArray(array);
		}

		return result;
	}

	/**
	 * 简单实现C#中string类型的format方法
	 * 
	 * @param pattern
	 * @param objects
	 * @return
	 */
	static public String Format(String pattern, Object... objects) {
		// // 避免非字符串类型的参数对表达式差生的副作用，在格式化之前将所有参数都转换为字符串类型
		// LinkedList<String> list = new LinkedList<String>();
		// for (Object object : objects) {
		// list.add(object.toString());
		// }
		//
		// return MessageFormat.format(pattern, list.toArray());

		String result = pattern;
		String placeholder = null;
		String replacement = null;
		for (int index = 0; index < objects.length; index++) {
			placeholder = "{" + index + "}";
			if (objects[index] == null)
				replacement = StringHelper.Empty();
			else
				replacement = objects[index].toString();

			// result = org.hibernate.util.StringHelper.replace(result,
			// placeholder, replacement);
			result = result.replace(placeholder, replacement);
		}

		return result;
	}

	/**
	 * 获取换行符
	 * 
	 * @return
	 */
	static public String NewLine() {
		return StringHelper.GetSystemProperty("line.separator");
	}

	/**
	 * 获取系统常量
	 * 
	 * @param val
	 * @return
	 */
	static public String GetSystemProperty(String val) {
		return System.getProperty(val.toString());
	}

	static public String ReinstateInvalidChar(String text) {
		if (IsNullOrEmpty(text))
			return "";
		return text.replace("&lt;", "<").replace("&gt;", ">")
				.replace("&quot;", "\"").replace("&apos;", "\'")
				.replace("&amp;", "&");
	}

	static public String ReplaceInvalidChar(String text) {
		if (IsNullOrEmpty(text))
			return "";

		String result = text.replace("&", "&amp;").replace("<", "&lt;")
				.replace(">", "&gt;").replace("\"", "&quot;")
				.replace("\'", "&apos;");
		return result;
	}

	static public String RemoveLastChar(String str) {
		if (IsNullOrEmpty(str))
			return null;
		return str.substring(0, str.length() - 1);
	}

	

	public static String HtmlEncode(String str) {
		return HtmlEncode(str, "UTF-8");
	}

	public static String HtmlEncode(String str, String code) {
		try {
			return java.net.URLEncoder.encode(str, code);
		} catch (UnsupportedEncodingException e) {
			return str;
		}
	}

	public static String HtmlDecode(String str) {
		try {
			return new String(str.getBytes("UTF-8"), "UTF-8");
		} catch (UnsupportedEncodingException e) {
			return str;
		}
	}

	public static String TruncateString(String origString, Integer maxLength) {
		if (StringHelper.IsNullOrEmpty(origString))
			return "";

		if (origString.length() <= maxLength)
			return origString;

		return origString.substring(0, maxLength);
	}

	public static String ReplaceSpecialChar(String queryStr) {
		return queryStr.replace("/", "//").replace("%", "/%")
				.replace("_", "/_");
	}

	/**
	 * 将array中的内容以delimiter为间隔拼接字符串
	 * 
	 * @param array
	 * @param delimiter
	 * @return
	 */
	public static String join(Object[] array, String delimiter) {
		if (array == null) {
			throw new IllegalArgumentException();
		}

		if (array.length == 0) {
			return "";
		}

		StringBuilder builder = new StringBuilder();
		for (Object item : array) {
			builder.append(item.toString() + delimiter);
		}
		builder.delete(builder.length() - delimiter.length(), builder.length());
		return builder.toString();
	}

	/**
	 * 将list中的内容以delimiter为间隔拼接字符串
	 * 
	 * @param list
	 * @param delimiter
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static String join(List list, String delimiter) {
		if (list == null) {
			throw new IllegalArgumentException();
		}

		return join(list.toArray(), delimiter);
	}

	/**
	 * 过滤特殊字符
	 * 
	 * @param str
	 * @return
	 */
	public static String StringFilter(String str) {
		// str = str.replaceAll("[\\?\\\\/'&:|< >\\*\"]", "");
		// 只允许字母和数字
		// String regEx = "[^a-zA-Z0-9]";
		// 清除掉所有特殊字符，保留"- ."
		String regEx = "[`~!@#$%^&*()+=|{}':_\";',\\[\\]<>\\\\/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，、？]";
		Pattern p = Pattern.compile(regEx);
		Matcher m = p.matcher(str);
		return m.replaceAll("").trim();
	}

	/*
	 * 判断是否为数字类型
	 */
	public static boolean IsNumeric(Object obj) {
		if (obj == null)
			return false;
		String str = obj.toString();
		if (str.matches("\\d *")) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 替换文件名的特殊字符
	 * 
	 * @param str
	 * @return
	 */
	public static String ReplaceInvalidChar4FileName(String str) {
		if (StringHelper.IsNullOrEmpty(str))
			return "";
		String reg = "[\\\\/:#*()`'?\"<>|]";
		Pattern p = Pattern.compile(reg);
		Matcher m = p.matcher(str);
		return m.replaceAll("").trim();
	}

}