package com.common;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * 解析XML字符串的工具类
 * @author shipiao
 *
 */
public class XmlStringUtils {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		 String text ="<xml><appid></appid>" +
		 				"<attach>订单额外描述</attach>"+
					    "<auth_code>120269300684844649</auth_code>"+
					    "<body>被扫支付测试</body>"+
					    "<device_info>1000</device_info>"+
					    "<goods_tag></goods_tag>"+
					    "<mch_id>10000100</mch_id>"+
					    "<nonce_str>8aaee146b1dee7cec9100add9b96cbe2</nonce_str>"+
					    "<out_trade_no>1415757673</out_trade_no>"+
					    "<spbill_create_ip>14.17.22.52</spbill_create_ip>"+
					    "<time_expire>1</time_expire>"+
					    "<total_fee>1</total_fee>"+
					    "<sign>C29DB7DB1FD4136B84AE35604756362C</sign>"+
					    "</xml> ";  
		            
		         long begin = System.currentTimeMillis();   
		        Map<String,Object>map= domParse( text );
		        System.out.println("map:"+map);
		         long after = System.currentTimeMillis();   
		          System.out.println("DOM用时"+(after-begin)+"毫秒");   

	}

	 /**	
	  * java自带的DOM解析
	  * dom解析用时是个不稳定的值在62-78毫秒之间. 
	  * @param protocolXML
	  */
	  public static Map<String,Object> domParse(String protocolXML) {   
          	Map<String,Object> result=null;
	        try {   
	             DocumentBuilderFactory factory = DocumentBuilderFactory   
	                     .newInstance();   
	             DocumentBuilder builder = factory.newDocumentBuilder();   
	             Document doc = builder   
	                     .parse(new InputSource(new StringReader(protocolXML)));   
	  
	             Element root = doc.getDocumentElement();   
	             NodeList books = root.getChildNodes();   
	             
	            if (books != null) {   
	            	result=new HashMap<String, Object>();
	                for (int i = 0; i < books.getLength(); i++) {
	                     Node book = books.item(i);   
	                     String nodeName=null;
	                     String nodeValue=null;
	                    try {							
							 nodeName=book.getNodeName();
							 nodeValue= book.getFirstChild().getNodeValue();
						} catch (NullPointerException e) {
							
						}
//	                    System.out.println("节点=" + nodeName + "\ttext="  
//	                             + nodeValue); 
	                    result.put(nodeName, nodeValue);
	                 }   
	             }  
	            System.out.println("result:"+result);
	         } catch (Exception e) {   
	             e.printStackTrace();   
	         }   
	        return result;
	     }   
	  
	  public static Map<String,Object> SaxNodeParse(String protocolXML)
	  {
		  Map<String,Object> result=null;
	        try {   
	             SAXParserFactory saxfac = SAXParserFactory.newInstance();      
	             SAXParser saxparser = saxfac.newSAXParser();   
	             TestSencondSAX   tsax = new TestSencondSAX();   
	             saxparser.parse(new InputSource(new StringReader(protocolXML)),tsax);   
	             result= tsax.getXmlMap();
	        } catch (Exception e) {   
	             e.printStackTrace();   
	         }   
	        return result;
	      
	  }
	  
	  public static Map<String,Object> SaxNodeQueryParse(String protocolXML)
	  {
		  Map<String,Object> result=null;
	        try {   
	             SAXParserFactory saxfac = SAXParserFactory.newInstance();      
	             SAXParser saxparser = saxfac.newSAXParser();   
	             TestSencondQuerySAX   tsax = new TestSencondQuerySAX();   
	             saxparser.parse(new InputSource(new StringReader(protocolXML)),tsax);   
	             result= tsax.getXmlMap();
	        } catch (Exception e) {   
	             e.printStackTrace();   
	         }   
	        return result;
	      
	  }
	  
	  /**
	   * java自带的SAX解析. 
	   * SAX用时是62毫秒,最快的.但是需要多写一个类 
	   * @param protocolXML
	   */
	  public static Map<String,Object> SaxParse(String protocolXML) {   
			Map<String,Object> result=null;
	        try {   
	             SAXParserFactory saxfac = SAXParserFactory.newInstance();      
	             SAXParser saxparser = saxfac.newSAXParser();   
	             TestSAX   tsax = new TestSAX();   
	             saxparser.parse(new InputSource(new StringReader(protocolXML)),tsax);   
	             result= tsax.getXmlMap();
	        } catch (Exception e) {   
	              
	         }   
	        return result;
	     } 
	}  

	class  TestSencondQuerySAX extends DefaultHandler{  
		private  Map<String,Object> result=null;   
	    @Override  
	    public void startElement(String uri, String localName, String qName,  
	            Attributes attributes) throws SAXException {  
	    	
	        if(qName.equals("item")) {  
	        	if(result==null)
	        		result=new HashMap<String, Object>();
	        	String name=attributes.getValue("name");
	        	String value=attributes.getValue("value");
	        	if(name!=null&&value!=null)
	        		result.put(name, value);  
	        }   
	    }  
	  
	    @Override  
	    public void characters(char[] ch, int start, int length) throws SAXException {  
	          
	    }  
	      
	    @Override  
	    public void endElement(String uri, String localName, String qName)  
	            throws SAXException {  
	         
	    } 
	    public Map<String,Object> getXmlMap(){
	    	return result;
	    }
	}

	class  TestSencondSAX extends DefaultHandler{  
		private  Map<String,Object> result=null;   
	    @Override  
	    public void startElement(String uri, String localName, String qName,  
	            Attributes attributes) throws SAXException {  
	    	
	        if(qName.equals("item")) {  
	        	if(result==null)
	        		result=new HashMap<String, Object>();
	        	String name=attributes.getValue("name");
	        	String value=attributes.getValue("value");
	        	if(name!=null&&value!=null)
	        		result.put(name, value);  
	        }   
	    }  
	  
	    @Override  
	    public void characters(char[] ch, int start, int length) throws SAXException {  
	          
	    }  
	      
	    @Override  
	    public void endElement(String uri, String localName, String qName)  
	            throws SAXException {  
	         
	    } 
	    public Map<String,Object> getXmlMap(){
	    	return result;
	    }
	}
     
	class  TestSAX extends DefaultHandler{   
		private  Map<String,Object> result=null;   
	    private StringBuffer buf;   
	    private String str;   
	    public TestSAX(){   
	         super();   
	     }   	        
	    public Map<String,Object> getXmlMap(){
	    	return result;
	    }
	    public void startDocument() throws SAXException{   
	         buf=new StringBuffer();   
	         result=new HashMap<String, Object>();
	         System.out.println("*******开始解析XML*******");   
	     }   
	       
	    public void endDocument() throws SAXException{           
	         System.out.println("*******XML解析结束*******");   
	     }   
	        
	    public void endElement(String namespaceURI,String localName,String fullName )throws SAXException{   
	         str = buf.toString();   
	         System.out.println("节点="+fullName+"\tvalue="+buf+" 长度="+buf.length());   
	         System.out.println();   
	         result.put(fullName, str);
	         buf.delete(0,buf.length());   
	       }   
	       
	    public void characters( char[] chars, int start, int length )throws SAXException{   
	        //将元素内容累加到StringBuffer中   
	         buf.append(chars,start,length);   
	     }   
	
	
	    
	    
}
